package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemLeaderboardBinding;
import app.firezone.synk.network.model.User;


import java.util.ArrayList;

public class LeaderboardAdapter extends RecyclerView.Adapter<LeaderboardAdapter.viewHolder> {

    ArrayList<User> list;
    Context context;

    public LeaderboardAdapter(ArrayList<User> list, Context context) {
        this.list = list;
        this.context = context;
    }

    @NonNull
    @Override
    public viewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(context);
        ItemLeaderboardBinding binding = ItemLeaderboardBinding.inflate(inflater, parent, false);
        return new viewHolder(binding);
    }

    @Override
    public void onBindViewHolder(@NonNull viewHolder holder, int position) {
        User model = list.get(position);

        // Rank (starts from 4)
        holder.binding.serialNo.setText(String.valueOf(position + 4));

        // Name and formatted score
        holder.binding.userNam.setText(model.getName());
        holder.binding.userScore.setText("₹" + formatAmount(model.getTotalEarning()));

        // Profile image
        if (model.getProfile() != null && !model.getProfile().isEmpty()) {
            Picasso.get()
                    .load(model.getProfile())
                    .placeholder(R.drawable.new_users)
                    .into(holder.binding.userPp);
        } else {
            holder.binding.userPp.setImageResource(R.drawable.new_users);
        }
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    public class viewHolder extends RecyclerView.ViewHolder {
        ItemLeaderboardBinding binding;

        public viewHolder(@NonNull ItemLeaderboardBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }
    }

    // Format amount like ₹12.5K or ₹1.3L
    private String formatAmount(double amount) {
        if (amount >= 100000) {
            return String.format("%.1fL", amount / 100000.0);
        } else if (amount >= 1000) {
            return String.format("%.1fK", amount / 1000.0);
        } else {
            return String.format("%.0f", amount);
        }
    }
}

